<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('news_events', function (Blueprint $table) {
            $table->json('additional_images')->nullable()->after('image_url');
        });

        Schema::table('achievements', function (Blueprint $table) {
            $table->json('additional_images')->nullable()->after('image_url');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('news_events', function (Blueprint $table) {
            $table->dropColumn('additional_images');
        });

        Schema::table('achievements', function (Blueprint $table) {
            $table->dropColumn('additional_images');
        });
    }
};
