{{-- Message Card Design 3: Modern Card with Border --}}
<div class="col-md-4">
    <div class="card h-100 shadow border-0"
        style="border-left: 5px solid var(--primary-color) !important; background: #f8f9fa;">
        <div class="card-header py-2 text-center"
            style="background-color: white; color: var(--primary-color); border-bottom: 3px solid var(--primary-color);">
            <h6 class="mb-0 fw-bold">{{ $title }}</h6>
        </div>
        <div class="card-body text-center"
            style="background-color: white; padding: 1.5rem !important; display: flex; flex-direction: column; align-items: center; justify-content: center;">
            @if($message->image_url)
                <div class="message-card-img-container">
                    <img src="{{ $message->image_url }}" alt="{{ $message->name }}" class="message-card-img"
                        style="border: none;" referrerpolicy="no-referrer">
                </div>
            @endif
            <h6 class="mb-1 fw-bold"
                style="color: {{ $settings['card_name_text_color'] ?? 'var(--primary-color)' }}; font-size: 1.1rem;">
                {{ $message->name }}
            </h6>
            <small class="d-block mb-3"
                style="color: {{ $settings['card_designation_text_color'] ?? '#6c757d' }}; font-size: 0.875rem;">{{ $message->designation }}</small>
            @if($message->slug)
                <a href="{{ route('message.show', $message->slug) }}" class="btn btn-sm rounded px-4 fw-bold"
                    style="background-color: {{ $settings['card_button_bg_color'] ?? 'var(--primary-color)' }}; color: {{ $settings['card_button_text_color'] ?? 'white' }}; border: none;">Read
                    Message</a>
            @endif
        </div>
    </div>
</div>